/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.ReactiveEnchantmentRecipe;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import com.rcx.materialis.datagen.MaterialisModifiers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TinkerSpellWriteRecipe
extends EnchantingApparatusRecipe {
    public static final RecipeSerializer<TinkerSpellWriteRecipe> SERIALIZER = new Serializer();
    public static final RecipeType<TinkerSpellWriteRecipe> SPELL_WRITE_TYPE = new ModRecipeType<TinkerSpellWriteRecipe>();
    public static final String RECIPE_ID = "tinker_spell_write";

    public TinkerSpellWriteRecipe(ResourceLocation id, List<Ingredient> pedestalItems, int cost) {
        this.pedestalItems = pedestalItems;
        this.id = id;
        this.sourceCost = cost;
    }

    public TinkerSpellWriteRecipe(List<Ingredient> pedestalItems) {
        this.pedestalItems = pedestalItems;
        this.id = new ResourceLocation("materialis", RECIPE_ID);
    }

    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable Player player) {
        int level = ToolStack.from((ItemStack)reagent).getModifierLevel(MaterialisModifiers.reactiveModifier.get());
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(pedestalItems);
        return !parchment.m_41619_() && !CasterUtil.getCaster((ItemStack)parchment).getSpell().isEmpty() && level > 0 && super.isMatch(pedestalItems, reagent, enchantingApparatusTile, player);
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return true;
    }

    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(pedestalItems);
        ISpellCaster caster = CasterUtil.getCaster((ItemStack)parchment);
        ReactiveCaster reactiveCaster = new ReactiveCaster(reagent);
        reactiveCaster.setSpell(caster.getSpell());
        return reagent.m_41777_();
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "materialis:tinker_spell_write");
        jsonobject.addProperty("sourceCost", (Number)this.getSourceCost());
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.pedestalItems) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        return jsonobject;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registry.f_122864_.m_7745_(new ResourceLocation("materialis", RECIPE_ID));
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TinkerSpellWriteRecipe> {
        public TinkerSpellWriteRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int cost = json.has("sourceCost") ? GsonHelper.m_13927_((JsonObject)json, (String)"sourceCost") : 0;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : pedestalItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = null;
                input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new TinkerSpellWriteRecipe(recipeId, stacks, cost);
        }

        @Nullable
        public TinkerSpellWriteRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            int cost = buffer.readInt();
            return new TinkerSpellWriteRecipe(recipeId, stacks, cost);
        }

        public void toNetwork(FriendlyByteBuf buf, TinkerSpellWriteRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            for (Ingredient i : recipe.pedestalItems) {
                i.m_43923_(buf);
            }
            buf.writeInt(recipe.sourceCost);
        }
    }

    private static class ModRecipeType<T extends Recipe<?>>
    implements RecipeType<T> {
        private ModRecipeType() {
        }

        public String toString() {
            return Registry.f_122864_.m_7981_((Object)this).toString();
        }
    }
}

